clear;clc
folder = 'D:\project\IGEM\rgb2';
R_values=[];G_values=[];B_values=[];RG_values=[];RB_values=[];GB_values=[];
image_files = dir(fullfile(folder, '*.png')); % 读取文件夹中所有 .jpg 文件
for i=1:6
    file_name = image_files(i).name;
    file_path = fullfile(folder, file_name);
    img = imread(file_path); % 读取图片
    %hsv_img = rgb2hsv(img);
    %hsv_img(:,:,3)=0.5*255;
    %img = hsv2rgb(hsv_img);
    %imshow(img); % 显示图片
    %h = drawrectangle(); % 手动绘制矩形
    %position = h.Position; % 获取矩形的坐标
    %cropped_img = imcrop(img, position); % 裁剪图片
   %imshow(cropped_img); % 显示图片
% 计算裁剪区域的 RGB 平均值
R_mean= mean(mean(img(:,:,1)));
G_mean= mean(mean(img(:,:,2)));
B_mean= mean(mean(img(:,:,3)));
RG_mean=R_mean/G_mean;
RB_mean=R_mean/B_mean;
GB_mean=G_mean/B_mean;

R_values = [R_values,R_mean];
G_values = [G_values,G_mean];
B_values = [B_values,B_mean];
RG_values =[RG_values,RG_mean];
RB_values =[GB_values,RB_mean];
GB_values =[GB_values,GB_mean];

end

concentration = [0,2,4,6,8,10]; % 不同图片的浓度

% 拟合 RGB 值与浓度关系
p_R = polyfit(concentration, R_values, 1); % 线性拟合
p_G = polyfit(concentration, G_values, 1);
p_B = polyfit(concentration, B_values, 1);
p_RG= polyfit(concentration, RG_values, 1); % 线性拟合
p_RB= polyfit(concentration, RB_values, 1); % 线性拟合
p_GB= polyfit(concentration, GB_values, 1); % 线性拟合

% 你也可以用更高阶的拟合
% p_R = polyfit(concentration, R_values, 2); % 二次拟合
% 生成浓度范围内的拟合值
fitted_R = polyval(p_R, concentration);
fitted_G = polyval(p_G, concentration);
fitted_B = polyval(p_B, concentration);
fitted_RG = polyval(p_RG, concentration);
fitted_RB = polyval(p_RB, concentration);
fitted_GB = polyval(p_GB, concentration);

% 绘制拟合曲线
figure(3);
subplot(3,1,1);
plot(concentration, R_values, 'ro', concentration, fitted_R, 'r-');
xlabel('Concentration');
ylabel('R Values');
legend('R data', 'R fit');
title('R vs Concentration');

subplot(3,1,2); 
plot(concentration, G_values, 'go', concentration, fitted_G, 'g-');
xlabel('Concentration');
ylabel('G Values');
legend('G data', 'G fit');
title('G vs Concentration');

subplot(3,1,3); 
plot(concentration, B_values, 'bo', concentration, fitted_B, 'b-');
xlabel('Concentration');
ylabel('B Values');
legend('B data', 'B fit');
title('B vs Concentration');

figure(4);
subplot(3,1,1);
plot(concentration, RG_values, 'ro', concentration, fitted_RG, 'r-');
xlabel('Concentration');
ylabel('R/G Values');
legend('R/G data', 'R/G fit');
title('R/G vs Concentration');
subplot(3,1,2);
plot(concentration, RB_values, 'go', concentration, fitted_RB, 'g-');
xlabel('Concentration');
ylabel('R/B Values');
legend('R/B data', 'R/B fit');
title('R/B vs Concentration');
subplot(3,1,3);
plot(concentration, GB_values, 'bo', concentration, fitted_GB, 'b-');
xlabel('Concentration');
ylabel('G/B Values');
legend('G/B data', 'G/B fit');
title('G/B vs Concentration');